package org.simantics.ui.selection;

import java.util.Objects;

import org.simantics.db.Resource;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Tuukka Lehtonen
 * @since 1.62.0 (1.60.0)
 */
public class ResourceVariableWorkbenchSelectionElement implements WorkbenchSelectionElement {

	private final Resource resource;
	private final Variable variable;
	private transient final int hash;

	public ResourceVariableWorkbenchSelectionElement(Resource resource, Variable variable) {
		this.resource = resource;
		this.variable = variable;
		this.hash = Objects.hashCode(resource) * 31 + Objects.hashCode(variable);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
		if (contentType instanceof AnyResource) {
			return (T) resource;
		} else if (contentType instanceof AnyVariable) {
			return (T) variable;
		}
		return null;
	}

	@Override
	public int hashCode() {
		return hash;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object)
			return true;
		else if (object == null)
			return false;
		else if (!(object instanceof ResourceVariableWorkbenchSelectionElement))
			return false;
		var o = (ResourceVariableWorkbenchSelectionElement) object;
		return Objects.equals(resource, o.resource) && Objects.equals(variable, o.variable);
	}

}
