/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.icons;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.cache.ProvisionException;

/**
 * @author Tuukka Lehtonen
 */
public final class ImageUtil {

    /**
     * @param graph
     * @param resource
     * @return
     * @throws DatabaseException
     * @throws ProvisionException if adapted ImageDescriptorProvider fails to
     *         provide the actual descriptor for some reason
     */
    public static ImageDescriptor adaptImageDescriptor(ReadGraph graph, Resource resource) throws DatabaseException {
        try {
            ImageDescriptorProvider provider = graph.adapt(resource, ImageDescriptorProvider.class);
            return provider.get();
        } catch (AdaptionException e) {
            return null;
        }
    }

}
