/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.dnd;

import java.io.IOException;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class SubgraphTransfer extends ByteArrayTransfer {

    private static final String          TYPENAME  = "graph";
    private static final int             TYPEID    = registerType(TYPENAME);
    private static final int[]           TYPEIDS   = new int[] { TYPEID };
    private static final String[]        TYPENAMES = new String[] { TYPENAME };

    public static final SubgraphTransfer INSTANCE = createInstance();

    SubgraphTransfer() {}

    public static SubgraphTransfer getInstance() {
        return INSTANCE;
    }

    public static SubgraphTransfer createInstance() {
        SubgraphTransfer result = new SubgraphTransfer();
        return result;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof TransferableGraph1) || !isSupportedType(transferData)) 
            DND.error(DND.ERROR_INVALID_DATA);

        Serializer s = Bindings.getSerializerUnchecked(TransferableGraph1.class);
        try {
            byte[] data = s.serialize(object);
            super.javaToNative(data, transferData);
        } catch (IOException e) {
            ErrorLogger.defaultLogError(e);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!isSupportedType(transferData)) return null;

        byte[] data = (byte[]) super.nativeToJava(transferData);
        try {
            Serializer s = Bindings.getSerializerUnchecked(TransferableGraph1.class);
            return s.deserialize(data);
        } catch (IOException e) {
            return null;
        }
    }

    protected String[] getTypeNames() {
        return TYPENAMES;
    }

    protected int[] getTypeIds() {
        return TYPEIDS;
    }

    protected boolean validate(Object object) {
        return object instanceof TransferableGraph1;
    }

}
