/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.dnd;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class LocalObjectTransferable implements Transferable, ClipboardOwner {

    //public static final String     TYPE_NAME = "application/x-java-jvm-local-objectref" + (new Long(System.currentTimeMillis())).toString() + ";class=java.lang.Object"; //$NON-NLS-1$;
    /**
     * For transferring JVM local objects as references, does not work between
     * applications. The System.currentTimeMillis suffix is added to prevent
     * application to application transfer.
     */
    public static final String     TYPE_NAME = "application/local-object-transfer-format" + (new Long(System.currentTimeMillis())).toString(); //$NON-NLS-1$;
    public static final DataFlavor FLAVOR    = new DataFlavor(TYPE_NAME, null);

    Object object;

    public LocalObjectTransferable(Object object) {
        this.object = new ByteArrayInputStream(new byte[0]);
        LocalObjectTransfer.getTransfer().setObject(object);
    }

    /**
     * Returns an array of flavors in which this <code>Transferable</code> can
     * provide the data. <code>DataFlavor.stringFlavor</code> is properly
     * supported. Support for <code>DataFlavor.plainTextFlavor</code> is
     * <b>deprecated</b>.
     * 
     * @return an array of length two, whose elements are <code>DataFlavor.
     *         stringFlavor</code> and <code>DataFlavor.plainTextFlavor</code>
     */
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[] { FLAVOR };
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(FLAVOR);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(FLAVOR))
            return object;
        throw new UnsupportedFlavorException(flavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

}
