/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.contribution;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.utils.ui.BundleUtils;

/**
 * @author Antti Villberg
 */
public class NameLabelButtonTrim extends Composite {

    LocalResourceManager resourceManager;

    public NameLabelButtonTrim(Composite parent) {
        super(parent, SWT.NONE);

        setLayout(new FillLayout());

        final NameLabelMode initialMode = NameLabelUtil.getNameLabelMode(Simantics.getSession());

        final Button b = new Button(this, SWT.PUSH);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), b);

        b.setToolTipText(tooltip(initialMode));
        b.setImage(resourceManager.createImage(getDescriptor(initialMode)));
        b.addSelectionListener(new SelectionAdapter() {

            NameLabelMode mode = initialMode; 

            @Override
            public void widgetSelected(SelectionEvent e) {
                mode = mode.cycle();
                b.setImage(resourceManager.createImage(getDescriptor(mode)));
                b.setToolTipText(tooltip(mode));
                NameLabelUtil.setNameLabelMode(Simantics.getSession(), mode);
            }
        });

    }

    private String tooltip(NameLabelMode currentMode) {
        return "Switch Name/Label Visualization Mode from " + currentMode.getLabel() + " to " + currentMode.cycle().getLabel();
    }

    private ImageDescriptor getDescriptor(NameLabelMode mode) {
        switch (mode) {
        case NAME: return BundleUtils.getImageDescriptorFromPlugin("org.simantics.ui", "/icons/N.png");
        case LABEL: return BundleUtils.getImageDescriptorFromPlugin("org.simantics.ui", "/icons/L.png");
        case NAME_AND_LABEL: return BundleUtils.getImageDescriptorFromPlugin("org.simantics.ui", "/icons/N+L.png");
        case LABEL_AND_NAME: return BundleUtils.getImageDescriptorFromPlugin("org.simantics.ui", "/icons/L+N.png");
        default: throw new IllegalArgumentException("unrecognized name/label mode: " + mode);
        }
    }

}