/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.colors;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.util.Bean;

/**
 * @author Antti Villberg
 */
public class Colors {

    private static double i2d(int value) {
        return (double) value / 255.0;
    }

    private static int d2i256(double value) {
        // TODO: how close to 256 can we go? 
        return (int)(255.9999*value);
    }

    public static Color irgb(RGB rgb) {
        return new RGBColor(i2d(rgb.red), i2d(rgb.green), i2d(rgb.blue));
    }

    public static Color irgb(int r, int g, int b) {
        return new RGBColor(i2d(r), i2d(g), i2d(b));
    }

    public static Color rgb(double r, double g, double b) {
    	return new RGBColor(r,g,b);
    }

    public static Color rgb(double[] rgb) {
    	return new RGBColor(rgb[0], rgb[1], rgb[2]);
    }

    /**
     * Returns AWT Color
     * @return
     */
    public static java.awt.Color awt(Color color) {
        return new java.awt.Color(d2i256(color.getR()), d2i256(color.getG()), d2i256(color.getB()));
    }

    public static java.awt.Color awt(org.simantics.datatypes.literal.RGB.Integer color) {
        return new java.awt.Color(color.red, color.green, color.blue);
    }

    /**
     * Returns SWT Color instance. Be aware that this is a native resource and
     * must be disposed of properly.
     * 
     * @param device
     * @param color
     * @return
     */
    public static org.eclipse.swt.graphics.Color swt(Device device, Color color) {
        return new org.eclipse.swt.graphics.Color(device,d2i256(color.getR()), d2i256(color.getG()), d2i256(color.getB()));
    }

    /**
     * Returns SWT Color instance. Be aware that this is a native resource and
     * must be disposed of properly.
     * 
     * @param device
     * @param color
     * @return
     */
    public static org.eclipse.swt.graphics.Color swt(Device device, org.simantics.datatypes.adt.Color color) {
        return new org.eclipse.swt.graphics.Color(device,d2i256(color.getR()), d2i256(color.getG()), d2i256(color.getB()));
    }

    /**
     * Returns SWT Color instance. Be aware that this is a native resource and
     * must be disposed of properly.
     * 
     * @param device
     * @param color
     * @return
     */
    public static org.eclipse.swt.graphics.Color swt(Device device, org.simantics.datatypes.literal.RGB.Integer color) {
        return new org.eclipse.swt.graphics.Color(device,color.red, color.green, color.blue);
    }

    /**
     * Returns JFace ColorDescriptor instance.
     * 
     * @param color
     * @return
     */
    public static ColorDescriptor swt(Color color) {
        return ColorDescriptor.createFrom( new RGB( d2i256(color.getR()), d2i256(color.getG()), d2i256(color.getB()) ) );
    }

    /**
     * Returns JFace ColorDescriptor instance.
     * 
     * @param color
     * @return
     */
    public static ColorDescriptor swt(org.simantics.datatypes.adt.Color color) {
        return ColorDescriptor.createFrom( new RGB( d2i256(color.getR()), d2i256(color.getG()), d2i256(color.getB()) ) );
    }

    /**
     * Returns JFace ColorDescriptor instance.
     * 
     * @param color
     * @return
     */
    public static ColorDescriptor swt(org.simantics.datatypes.literal.RGB.Integer color) {
        return ColorDescriptor.createFrom( new RGB(color.red, color.green, color.blue) );
    }

    public static ColorDescriptor swt(Bean bean) throws BindingException {
    	Integer r = (Integer)bean.getField("r", Bindings.INTEGER);
    	Integer g = (Integer)bean.getField("g", Bindings.INTEGER);
    	Integer b = (Integer)bean.getField("b", Bindings.INTEGER);
        return ColorDescriptor.createFrom( new RGB(r, g, b) );
    }

    public static RGB rgb(Color color) {
        return new RGB(d2i256(color.getR()), d2i256(color.getG()), d2i256(color.getB()));
    }
    
    public static org.simantics.datatypes.literal.RGB.Integer integerRGB(java.awt.Color awt) {
    	return new org.simantics.datatypes.literal.RGB.Integer(awt.getRed(), awt.getGreen(), awt.getBlue());
    }

}
