/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.auth.model;

import org.simantics.db.management.discovery.ServerInfo;

/**
 * @author Tuukka Lehtonen
 */
public class LoginModel {

    private final ServerInfo server;

    private String           name;

    private String           password;
    
    private boolean          remember;
    
    private final boolean    loadedFromStore;
    
    public LoginModel(ServerInfo server) {
        this(server, "Default User", "", false, false); 
    }

    public LoginModel(ServerInfo server, String name, String password, boolean remember, boolean loadedFromStore) {
        assert server != null;
        
        this.server = server;
        this.name = name;
        this.password = password;
        this.remember = remember;
        this.loadedFromStore = loadedFromStore;
    }

    public ServerInfo getServer() {
        return server;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRemember() {
        return remember;
    }

    public void setRemember(boolean remember) {
        this.remember = remember;
    }

    public boolean isLoadedFromStore() {
        return loadedFromStore;
    }

    @Override
    public String toString() {
        return "LoginModel [" + server + ", " + name + ", remember=" + remember + ", loaded=" + loadedFromStore + "]";
    }
    
}
