/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.structural2.variables.AbstractVariableConnectionPointDescriptor;

public class BrowseConnectionDescriptor
extends AbstractVariableConnectionPointDescriptor {
    public Variable base;
    public String rel;

    public BrowseConnectionDescriptor(Variable base, String rel) {
        this.base = base;
        this.rel = rel;
    }

    public int hashCode() {
        return this.base.hashCode() + 31 * this.rel.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BrowseConnectionDescriptor)) {
            return false;
        }
        BrowseConnectionDescriptor r = (BrowseConnectionDescriptor)object;
        if (!r.rel.equals(this.rel)) {
            return false;
        }
        return r.base.equals(this.base);
    }

    @Override
    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new ComputeVariable(this), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        return this.getVariable(graph).getURI(graph);
    }

    @Override
    public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException {
        return this.getVariable(graph).getPossiblePredicateResource(graph);
    }

    @Override
    public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException {
        String parentURI;
        Variable parent;
        Variable parentParent;
        Variable baseParent = this.base.getParent(graph);
        if (baseParent.equals(parentParent = (parent = possiblyStructuralCp.getParent(graph)).getParent(graph)) && !parent.equals(this.base)) {
            return false;
        }
        String descURI = this.getURI(graph);
        if (descURI.startsWith(parentURI = parent.getURI(graph))) {
            if ('/' == descURI.charAt(parentURI.length())) {
                return true;
            }
            return descURI.endsWith(possiblyStructuralCp.getName(graph));
        }
        return false;
    }

    static class ComputeVariable
    extends UnaryRead<BrowseConnectionDescriptor, Variable> {
        public ComputeVariable(BrowseConnectionDescriptor desc) {
            super((Object)desc);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            return ((BrowseConnectionDescriptor)this.parameter).base.browse(graph, ((BrowseConnectionDescriptor)this.parameter).rel);
        }
    }
}

