/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.structural2.Functions;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;

public abstract class AbstractVariableConnectionPointDescriptor
implements VariableConnectionPointDescriptor {
    @Override
    public Collection<Functions.InterfaceResolution> getInterfaceDescription(ReadGraph graph) throws DatabaseException {
        return (Collection)graph.syncRequest((Read)new ComputeInterfaceDescription(this), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public boolean isLeaf(ReadGraph graph) throws DatabaseException {
        Collection<Functions.InterfaceResolution> inf = this.getInterfaceDescription(graph);
        if (inf == null) {
            return true;
        }
        return inf.isEmpty();
    }

    @Override
    public boolean hasClassification(ReadGraph graph, String classification) throws DatabaseException {
        PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(this.getConnectionPointResource(graph)), (AsyncProcedure)TransientCacheAsyncListener.instance());
        return info.hasClassification(classification);
    }

    @Override
    public String getRelativeRVI(ReadGraph graph, Variable base) throws DatabaseException {
        String var = this.getURI(graph);
        String baseURI = base.getURI(graph);
        return Variables.getRelativeRVI((String)baseURI, (String)var);
    }

    static class ComputeInterfaceDescription
    extends UnaryRead<AbstractVariableConnectionPointDescriptor, Collection<Functions.InterfaceResolution>> {
        public ComputeInterfaceDescription(AbstractVariableConnectionPointDescriptor desc) {
            super((Object)desc);
        }

        public Collection<Functions.InterfaceResolution> perform(ReadGraph graph) throws DatabaseException {
            return Functions.computeInterfacePaths(graph, ((AbstractVariableConnectionPointDescriptor)this.parameter).getVariable(graph).getParent(graph));
        }
    }
}

