/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.structural2.variables.AbstractVariableConnectionPointDescriptor;
import org.simantics.utils.datastructures.Pair;

public class PairConnectionDescriptor
extends AbstractVariableConnectionPointDescriptor {
    public Variable base;
    public Pair<String, Resource> pair;

    public PairConnectionDescriptor(Variable base, Pair<String, Resource> pair) {
        this.base = base;
        this.pair = pair;
    }

    public int hashCode() {
        return this.base.hashCode() + 31 * this.pair.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PairConnectionDescriptor)) {
            return false;
        }
        PairConnectionDescriptor r = (PairConnectionDescriptor)object;
        if (!r.pair.equals(this.pair)) {
            return false;
        }
        return r.base.equals(this.base);
    }

    @Override
    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new ComputeVariable(this), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        return this.getVariable(graph).getURI(graph);
    }

    @Override
    public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException {
        return this.getVariable(graph).getPossiblePredicateResource(graph);
    }

    @Override
    public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException {
        String parentURI;
        Variable parent = possiblyStructuralCp.getParent(graph);
        String descURI = this.getURI(graph);
        if (descURI.startsWith(parentURI = parent.getURI(graph))) {
            if ('/' == descURI.charAt(parentURI.length())) {
                return true;
            }
            return descURI.endsWith(possiblyStructuralCp.getName(graph));
        }
        return false;
    }

    static class ComputeVariable
    extends UnaryRead<PairConnectionDescriptor, Variable> {
        public ComputeVariable(PairConnectionDescriptor desc) {
            super((Object)desc);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            return ((PairConnectionDescriptor)this.parameter).base.getChild(graph, (String)((PairConnectionDescriptor)this.parameter).pair.first).getProperty(graph, (Resource)((PairConnectionDescriptor)this.parameter).pair.second);
        }
    }
}

