/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.Connection2;
import org.simantics.structural2.variables.ConnectionBrowser;
import org.simantics.structural2.variables.PairConnectionDescriptor;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedConnection
implements Connection,
Connection2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedConnection.class);
    private final Variable procedural;
    private final Collection<Pair<String, Resource>> cps = new ArrayList<Pair<String, Resource>>();

    public FixedConnection(Variable procedural) {
        this.procedural = procedural;
    }

    public void addAll(List<Pair<String, Resource>> cps) throws DatabaseException {
        for (Pair<String, Resource> cp : cps) {
            this.cps.add(cp);
        }
    }

    public int size() {
        return this.cps.size();
    }

    public void resolveInternalConnectionDescriptors(ReadGraph graph, Variable curConfiguration, Collection<VariableConnectionPointDescriptor> result) throws DatabaseException {
        for (Pair<String, Resource> cpzz : this.cps) {
            if (cpzz.first == null) continue;
            result.add(new PairConnectionDescriptor(curConfiguration, cpzz));
        }
    }

    @Override
    public Collection<Variable> getConnectionPoints(ReadGraph graph, Resource relationType) throws DatabaseException {
        THashSet result = new THashSet();
        for (VariableConnectionPointDescriptor desc : this.getConnectionPointDescriptors(graph, relationType)) {
            result.add(desc.getVariable(graph));
        }
        return result;
    }

    @Override
    public Collection<String> getConnectionPointURIs(ReadGraph graph, Resource relationType) throws DatabaseException {
        THashSet result = new THashSet();
        for (VariableConnectionPointDescriptor desc : this.getConnectionPointDescriptors(graph, relationType)) {
            result.add(desc.getURI(graph));
        }
        return result;
    }

    @Override
    public Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph, Resource relationType) throws DatabaseException {
        THashSet result = new THashSet();
        for (Pair<String, Resource> cp : this.cps) {
            if (cp.first == null) {
                result.addAll(ConnectionBrowser.flatten(graph, this.procedural, (Resource)cp.second, relationType));
                continue;
            }
            result.add(new PairConnectionDescriptor(this.procedural, cp));
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.cps == null ? 0 : this.cps.hashCode());
        result = 31 * result + (this.procedural == null ? 0 : this.procedural.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedConnection other = (FixedConnection)obj;
        if (this.cps == null ? other.cps != null : !this.cps.equals(other.cps)) {
            return false;
        }
        return !(this.procedural == null ? other.procedural != null : !this.procedural.equals(other.procedural));
    }

    @Override
    public Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph, Variable component, Resource relationType) throws DatabaseException {
        THashSet result = new THashSet();
        Variable procedural = component.getParent(graph);
        for (Pair<String, Resource> cp : this.cps) {
            Variable base = cp.first == null ? procedural : procedural.getChild(graph, (String)cp.first);
            Variable cp2 = base.getPossibleProperty(graph, (Resource)cp.second);
            if (cp2 != null) {
                result.addAll(ConnectionBrowser.flatten(graph, base, (Resource)cp.second, relationType));
                continue;
            }
            FixedConnection.logWarn(graph, cp, base, procedural);
        }
        return result;
    }

    @Override
    public Collection<Variable> getConnectionPoints(ReadGraph graph, Variable component, Resource relationType) throws DatabaseException {
        THashSet result = new THashSet();
        Variable procedural = component.getParent(graph);
        for (Pair<String, Resource> cp : this.cps) {
            Variable base = cp.first == null ? procedural : procedural.getChild(graph, (String)cp.first);
            Variable cp2 = base.getPossibleProperty(graph, (Resource)cp.second);
            if (cp2 != null) {
                for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, base, (Resource)cp.second, relationType)) {
                    result.add(desc.getVariable(graph));
                }
                continue;
            }
            FixedConnection.logWarn(graph, cp, base, procedural);
        }
        return result;
    }

    @Override
    public Collection<String> getConnectionPointURIs(ReadGraph graph, Variable component, Resource relationType) throws DatabaseException {
        THashSet result = new THashSet();
        Variable procedural = component.getParent(graph);
        for (Pair<String, Resource> cp : this.cps) {
            Variable base = cp.first == null ? procedural : procedural.getChild(graph, (String)cp.first);
            Variable cp2 = base.getPossibleProperty(graph, (Resource)cp.second);
            if (cp2 != null) {
                for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, base, (Resource)cp.second, relationType)) {
                    result.add(desc.getURI(graph));
                }
                continue;
            }
            FixedConnection.logWarn(graph, cp, base, procedural);
        }
        return result;
    }

    @Override
    public Connection2 getConnection2() {
        return this;
    }

    private static void logWarn(ReadGraph graph, Pair<String, Resource> cp, Variable base, Variable procedural) throws DatabaseException {
        LOGGER.warn("no cp " + (String)cp.first + " for " + base.getURI(graph));
        LOGGER.warn("    proc: " + procedural.getURI(graph));
        LOGGER.warn("    rel: " + graph.getURI((Resource)cp.second));
        LOGGER.warn("    base: " + base.getURI(graph));
    }
}

