/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.structural2.variables.AbstractVariableConnectionPointDescriptor;

public class ComponentConnectionDescriptor
extends AbstractVariableConnectionPointDescriptor {
    public Variable component;
    public Resource cp;

    public ComponentConnectionDescriptor(Variable component, Resource cp) {
        this.component = component;
        this.cp = cp;
    }

    public int hashCode() {
        return this.component.hashCode() + 31 * this.cp.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ComponentConnectionDescriptor)) {
            return false;
        }
        ComponentConnectionDescriptor r = (ComponentConnectionDescriptor)object;
        if (!r.cp.equals(this.cp)) {
            return false;
        }
        return r.component.equals(this.component);
    }

    @Override
    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new ComputeVariable(this), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        return this.getVariable(graph).getURI(graph);
    }

    @Override
    public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException {
        return this.getVariable(graph).getPossiblePredicateResource(graph);
    }

    @Override
    public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException {
        String parentURI;
        Variable parent = possiblyStructuralCp.getParent(graph);
        String descURI = this.getURI(graph);
        if (descURI.startsWith(parentURI = parent.getURI(graph))) {
            if ('/' == descURI.charAt(parentURI.length())) {
                return true;
            }
            return descURI.endsWith(possiblyStructuralCp.getName(graph));
        }
        return false;
    }

    static class ComputeVariable
    extends UnaryRead<ComponentConnectionDescriptor, Variable> {
        public ComputeVariable(ComponentConnectionDescriptor desc) {
            super((Object)desc);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            return ((ComponentConnectionDescriptor)this.parameter).component.getProperty(graph, ((ComponentConnectionDescriptor)this.parameter).cp);
        }
    }
}

