/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.validate;

import gnu.trove.set.hash.THashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.validate.IErrorReporter;
import org.simantics.structural2.validate.StdoutReporter;

public class ValidateStructural {
    ReadGraph g;
    Layer0 b;
    StructuralResource2 sr;
    boolean validateTypesRecursively;
    THashSet<Resource> validatedTypes = new THashSet();
    IErrorReporter reporter = new StdoutReporter();

    public ValidateStructural(ReadGraph g, boolean validateTypesRecursively) {
        this.g = g;
        this.b = Layer0.getInstance((ReadGraph)g);
        this.sr = StructuralResource2.getInstance((ReadGraph)g);
        this.validateTypesRecursively = validateTypesRecursively;
    }

    public void setReporter(IErrorReporter reporter) {
        this.reporter = reporter;
    }

    private void checkUniqueNames(Resource rootComposite) throws DatabaseException {
        THashSet names = new THashSet();
        this.checkUniqueNames(rootComposite, (THashSet<String>)names);
    }

    private void checkUniqueNames(Resource composite, THashSet<String> names) throws DatabaseException {
        for (Resource component : this.g.getObjects(composite, this.b.ConsistsOf)) {
            String name = null;
            try {
                name = (String)this.g.getRelatedValue(component, this.b.HasName);
            }
            catch (DatabaseException databaseException) {
                this.reporter.report("Component does not have a name or there are two names.", component);
            }
            if (name != null && !names.add((Object)name)) {
                this.reporter.report("Name '" + name + "' is not unique.", component);
            }
            if (!this.g.isInstanceOf(component, this.sr.Composite)) continue;
            this.checkUniqueNames(composite, names);
        }
    }

    public void validateComponent(Resource component) throws DatabaseException {
        if (!this.g.isInstanceOf(component, this.sr.Component)) {
            this.reporter.report(NameUtils.getSafeName((ReadGraph)this.g, (Resource)component) + " is not a component.", component);
            return;
        }
        if (this.g.isInstanceOf(component, this.sr.Composite)) {
            for (Resource child : this.g.getObjects(component, this.b.ConsistsOf)) {
                this.validateComponent(child);
            }
        }
    }

    public void validateRootComposite(Resource rootComposite) throws DatabaseException {
        this.checkUniqueNames(rootComposite);
        this.validateComponent(rootComposite);
    }

    public void validateComponentType(Resource componentType) throws DatabaseException {
        Resource rootComposite = null;
        try {
            rootComposite = this.g.getPossibleObject(componentType, this.sr.IsDefinedBy);
        }
        catch (ManyObjectsForFunctionalRelationException manyObjectsForFunctionalRelationException) {
            this.reporter.report("A user component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)componentType) + " has multiple definitions.", componentType);
        }
        if (rootComposite != null) {
            this.validateRootComposite(rootComposite);
        }
    }
}

