/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.utils;

import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.changeset.ChangeVisitor;
import org.simantics.db.layer0.changeset.MetadataUtils;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.layer0.request.ModelInstances;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralChangeVisitor;
import org.simantics.structural2.utils.StructuralUtils;

public class StructuralMetadataUtils {
    private static ChangeVisitor getChangeVisitor(ReadGraph graph, final Resource model, final StructuralChangeVisitor visitor) throws DatabaseException {
        return new ChangeVisitor(graph){
            Layer0 L0;
            StructuralResource2 STR;
            THashSet<Resource> visited;
            Resource IsLiftedAs;
            {
                this.L0 = Layer0.getInstance((ReadGraph)readGraph);
                this.STR = StructuralResource2.getInstance((ReadGraph)readGraph);
                this.visited = new THashSet();
                this.IsLiftedAs = readGraph.getResource("http://www.simantics.org/Diagram-2.2/IsLiftedAs");
            }

            public void visit(ReadGraph graph, DependencyChanges.Change change, boolean inverted) throws DatabaseException {
                switch (change.getType()) {
                    case COMPONENT_ADDITION: {
                        DependencyChanges.ComponentAddition addition = (DependencyChanges.ComponentAddition)change;
                        if (inverted) {
                            visitor.visitComponentChange(graph, addition.parent, false);
                            break;
                        }
                        visitor.visitComponentChange(graph, addition.component, true);
                        break;
                    }
                    case COMPONENT_MODIFICATION: {
                        DependencyChanges.ComponentModification modification = (DependencyChanges.ComponentModification)change;
                        this.handleModification(graph, modification.component);
                        break;
                    }
                    case COMPONENT_REMOVAL: {
                        DependencyChanges.ComponentRemoval removal = (DependencyChanges.ComponentRemoval)change;
                        if (inverted) {
                            visitor.visitComponentChange(graph, removal.component, true);
                            break;
                        }
                        visitor.visitComponentChange(graph, removal.parent, false);
                        break;
                    }
                }
            }

            void handleModification(ReadGraph graph, Resource resource) throws DatabaseException {
                if (!this.visited.add((Object)resource)) {
                    return;
                }
                if (!graph.hasStatement(resource)) {
                    return;
                }
                Set types = graph.getTypes(resource);
                if (types.contains(this.STR.Component)) {
                    visitor.visitComponentChange(graph, resource, true);
                } else if (types.contains(this.STR.Connection)) {
                    for (Resource connection : StructuralUtils.getRelatedConnections((RequestProcessor)graph, resource)) {
                        this.handleConnectionChange(graph, connection);
                    }
                } else if (types.contains(this.STR.ConnectionJoin)) {
                    for (Resource connection : StructuralUtils.getRelatedConnectionsOfConnectionJoin((RequestProcessor)graph, resource)) {
                        this.handleConnectionChange(graph, connection);
                    }
                } else if (types.contains(this.STR.ComponentType)) {
                    for (Resource instance : ((Map)graph.syncRequest((Read)new ModelInstances(model, resource))).values()) {
                        visitor.visitComponentChange(graph, instance, true);
                    }
                } else {
                    Resource connectionRelation = graph.getPossibleObject(resource, this.IsLiftedAs);
                    if (connectionRelation != null) {
                        this.handleConnectionRelation(graph, connectionRelation);
                    } else {
                        for (Resource parent : graph.getObjects(resource, this.L0.IsDependencyOf)) {
                            this.handleModification(graph, parent);
                        }
                    }
                }
            }

            void handleConnectionChange(ReadGraph graph, Resource connection) throws DatabaseException {
                for (Resource component : graph.getObjects(connection, this.STR.Connects)) {
                    visitor.visitComponentChange(graph, component, true);
                }
                for (Resource connectionRelation : graph.getObjects(connection, this.STR.Binds)) {
                    this.handleConnectionRelation(graph, connectionRelation);
                }
            }

            void handleConnectionRelation(ReadGraph graph, Resource connectionRelation) throws DatabaseException {
                Resource componentType = graph.getPossibleObject(connectionRelation, this.L0.HasDomain);
                if (componentType == null) {
                    return;
                }
                for (Resource instance : ((Map)graph.syncRequest((Read)new ModelInstances(model, componentType))).values()) {
                    for (Resource connection2 : graph.getObjects(instance, connectionRelation)) {
                        this.handleConnectionChange(graph, connection2);
                    }
                }
            }
        };
    }

    public static void visitStructuralChangesFrom(ReadGraph graph, Resource model, long fromRevision, StructuralChangeVisitor visitor) throws DatabaseException {
        MetadataUtils.visitDependencyChangesFrom((ReadGraph)graph, (Resource)model, (long)fromRevision, (ChangeVisitor)StructuralMetadataUtils.getChangeVisitor(graph, model, visitor));
    }

    public static void visitStructuralChangesFrom(ReadGraph graph, Resource model, DependencyChanges.Change[] changes, StructuralChangeVisitor visitor) throws DatabaseException {
        MetadataUtils.visitDependencyChangesFrom2((ReadGraph)graph, (Resource)model, (DependencyChanges.Change[])changes, (ChangeVisitor)StructuralMetadataUtils.getChangeVisitor(graph, model, visitor));
    }
}

