/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.scl;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.internal.Activator;

public interface ComponentTypeScriptPhaseContribution {
    public Phase[] getPhases(ReadGraph var1, Resource var2, Resource var3) throws DatabaseException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Phase[] getPhasesForScript(ReadGraph graph, Resource script) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource componentType = graph.getPossibleObject(script, STR.ComponentType_hasScript_Inverse);
        BundleContext ctx = Activator.getContext();
        try {
            ServiceReference[] refs = ctx.getAllServiceReferences(ComponentTypeScriptPhaseContribution.class.getName(), null);
            if (refs == null) return null;
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return null;
                }
                ServiceReference ref = serviceReferenceArray[n2];
                ComponentTypeScriptPhaseContribution c = (ComponentTypeScriptPhaseContribution)ctx.getService(ref);
                try {
                    Phase[] phases = c.getPhases(graph, script, componentType);
                    if (phases != null) {
                        Phase[] phaseArray = phases;
                        return phaseArray;
                    }
                }
                finally {
                    ctx.ungetService(ref);
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException | IllegalStateException | SecurityException | InvalidSyntaxException e) {
            throw new DatabaseException(e);
        }
    }

    public static Phase[] getPhasesForScript(RequestProcessor proc, Resource script) throws DatabaseException {
        return (Phase[])proc.syncRequest(graph -> ComponentTypeScriptPhaseContribution.getPhasesForScript(graph, script));
    }

    public static class Phase {
        public final String id;
        public final String label;

        public Phase(String id, String label) {
            this.id = id;
            this.label = label;
        }
    }
}

