/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.modelingRules;

import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural2.modelingRules.AbstractModelingRules;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IAttachmentRelationMap;
import org.simantics.structural2.modelingRules.IConnectionPoint;

public class SimpleModelingRules
extends AbstractModelingRules {
    private Resource connectionType;
    private Resource attachmentRelation;
    IAttachmentRelationMap attachmentRelations = new IAttachmentRelationMap(){

        @Override
        public Resource get(ReadGraph g, CPTerminal cp) throws DatabaseException {
            return SimpleModelingRules.this.attachmentRelation;
        }
    };

    public SimpleModelingRules(Resource connectionType, Resource attachmentRelation) {
        this.connectionType = connectionType;
        this.attachmentRelation = attachmentRelation;
    }

    @Override
    public ConnectionJudgement judgeConnection(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        ConnectionJudgement judgement = new ConnectionJudgement(this.connectionType);
        judgement.attachmentRelations = this.attachmentRelations;
        return judgement;
    }

    @Override
    public Resource computeConnectionType(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        return this.connectionType;
    }

    @Override
    public IAttachmentRelationMap getAttachmentRelations(ReadGraph g, Resource connection) {
        return this.attachmentRelations;
    }

    @Override
    public Set<CPTerminal> resolveTerminals(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        throw new UnsupportedOperationException("Simple Modelling Rules do not process actual connection points");
    }
}

