/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.internal.queries;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.queries.Terminal;
import org.simantics.structural2.utils.StructuralUtils;

public class ConnectedTo
extends ResourceRead2<Set<Terminal>> {
    private static final boolean DEBUG = false;

    public ConnectedTo(Resource component, Resource connectionPoint) {
        super(component, connectionPoint);
    }

    public Set<Terminal> perform(ReadGraph graph) throws DatabaseException {
        Collection connections = graph.getObjects(this.resource, this.resource2);
        if (connections.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Resource> reachableConnections = new HashSet<Resource>();
        for (Resource connection : connections) {
            reachableConnections.addAll(StructuralUtils.getRelatedConnections((RequestProcessor)graph, connection));
        }
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        HashSet<Terminal> connectedTo = new HashSet<Terminal>();
        for (Resource connection : reachableConnections) {
            for (Statement stm : graph.getStatements(connection, sr.Connects)) {
                Resource connectionPoint2 = graph.getInverse(stm.getPredicate());
                if (this.resource2.equals(connectionPoint2) && this.resource.equals(stm.getObject())) continue;
                connectedTo.add(new Terminal(stm.getObject(), connectionPoint2));
            }
        }
        return connectedTo;
    }
}

