package org.simantics.structural2.variables;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardExpressionGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural2.scl.CompileProceduralExpressionValueRequest;

public class StructuralProceduralExpressionPropertyVariable extends StandardExpressionGraphPropertyVariable {

	public StructuralProceduralExpressionPropertyVariable(ReadGraph graph,
			Variable parent, Resource property, String expressionText)
			throws DatabaseException {
		super(graph, parent, property, expressionText);
	}

	@Override
	protected Object compute(ReadGraph graph, Variable context) throws DatabaseException {
		return CompileProceduralExpressionValueRequest.compileAndEvaluate(graph, expressionText, context);
	}

	@Override
	protected Object compute(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
		return CompileProceduralExpressionValueRequest.compileAndEvaluate(graph, expressionText, context);
	}

}
