package org.simantics.structural2.variables;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.Pair;

public class PairConnectionDescriptor extends AbstractVariableConnectionPointDescriptor {
	
	public Variable base;
	public Pair<String,Resource> pair;
	
	public PairConnectionDescriptor(Variable base, Pair<String,Resource> pair) {
		this.base = base;
		this.pair = pair;
	}
	@Override
	public int hashCode() {
		return base.hashCode() + 31*pair.hashCode();
	}
	@Override
	public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof PairConnectionDescriptor))
            return false;
        PairConnectionDescriptor r = (PairConnectionDescriptor)object;
        if(!r.pair.equals(pair)) return false;
        if(!r.base.equals(base)) return false;
        return true;
	}
	
	static class ComputeVariable extends UnaryRead<PairConnectionDescriptor, Variable> {

		public ComputeVariable(PairConnectionDescriptor desc) {
			super(desc);
		}

		@Override
		public Variable perform(ReadGraph graph) throws DatabaseException {
			return parameter.base.getChild(graph, parameter.pair.first).getProperty(graph, parameter.pair.second);
		}
		
	}
	@Override
	public Variable getVariable(ReadGraph graph) throws DatabaseException {
		return graph.syncRequest(new ComputeVariable(this), TransientCacheAsyncListener.<Variable>instance());
	}
	public String getURI(ReadGraph graph) throws DatabaseException {
		return getVariable(graph).getURI(graph);
	}
	@Override
	public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException {
		return getVariable(graph).getPossiblePredicateResource(graph);
	}
	
	@Override
	public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException {
		
		Variable parent = possiblyStructuralCp.getParent(graph);
		
		String descURI = getURI(graph);
		String parentURI = parent.getURI(graph);
		if(descURI.startsWith(parentURI)) {
			// Children are in substructure
			if('/' == descURI.charAt(parentURI.length())) return true;
			// Otherwise require exact match
			return descURI.endsWith(possiblyStructuralCp.getName(graph));
		} else {
			return false;
		}
		
	}
	
}