package org.simantics.structural2.variables;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class ComponentConnectionDescriptor extends AbstractVariableConnectionPointDescriptor {
	
	public Variable component;
	public Resource cp;
	
	public ComponentConnectionDescriptor(Variable component, Resource cp) {
		this.component = component;
		this.cp = cp;
	}
	@Override
	public int hashCode() {
		return component.hashCode() + 31*cp.hashCode();
	}
	@Override
	public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof ComponentConnectionDescriptor))
            return false;
        ComponentConnectionDescriptor r = (ComponentConnectionDescriptor)object;
        if(!r.cp.equals(cp)) return false;
        if(!r.component.equals(component)) return false;
        return true;
	}

	static class ComputeVariable extends UnaryRead<ComponentConnectionDescriptor, Variable> {

		public ComputeVariable(ComponentConnectionDescriptor desc) {
			super(desc);
		}

		@Override
		public Variable perform(ReadGraph graph) throws DatabaseException {
			return parameter.component.getProperty(graph, parameter.cp);
		}
		
	}
	@Override
	public Variable getVariable(ReadGraph graph) throws DatabaseException {
		return graph.syncRequest(new ComputeVariable(this), TransientCacheAsyncListener.<Variable>instance());
	}
	public String getURI(ReadGraph graph) throws DatabaseException {
		return getVariable(graph).getURI(graph);
	}
	@Override
	public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException {
		return getVariable(graph).getPossiblePredicateResource(graph);
	}
	
	@Override
	public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException {

		Variable parent = possiblyStructuralCp.getParent(graph);
		
		String descURI = getURI(graph);
		String parentURI = parent.getURI(graph);
		if(descURI.startsWith(parentURI)) {
			// Children are in substructure
			if('/' == descURI.charAt(parentURI.length())) return true;
			// Otherwise require exact match
			return descURI.endsWith(possiblyStructuralCp.getName(graph));
		} else {
			return false;
		}
		
	}
	
}