package org.simantics.structural2.variables;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.structural2.Functions;
import org.simantics.structural2.Functions.InterfaceResolution;

abstract public class AbstractVariableConnectionPointDescriptor implements VariableConnectionPointDescriptor {

	static class ComputeInterfaceDescription extends UnaryRead<AbstractVariableConnectionPointDescriptor, Collection<InterfaceResolution>> {

		public ComputeInterfaceDescription(AbstractVariableConnectionPointDescriptor desc) {
			super(desc);
		}

		@Override
		public Collection<InterfaceResolution> perform(ReadGraph graph) throws DatabaseException {
			return Functions.computeInterfacePaths(graph, parameter.getVariable(graph).getParent(graph));
		}
		
	}
	
	@Override
	public Collection<InterfaceResolution> getInterfaceDescription(ReadGraph graph) throws DatabaseException {
		return graph.syncRequest(new ComputeInterfaceDescription(this), TransientCacheAsyncListener.<Collection<InterfaceResolution>>instance());
	}
	
	@Override
	public boolean isLeaf(ReadGraph graph) throws DatabaseException {
		
		Collection<InterfaceResolution> inf = getInterfaceDescription(graph);
		if(inf == null) return true;
		return inf.isEmpty();
		
	}
	
	@Override
	public boolean hasClassification(ReadGraph graph, String classification) throws DatabaseException {
		
    	PropertyInfo info = graph.syncRequest(new PropertyInfoRequest(getConnectionPointResource(graph)), TransientCacheAsyncListener.<PropertyInfo>instance());
    	return info.hasClassification(classification);
		
	}
	
	@Override
	public String getRelativeRVI(ReadGraph graph, Variable base) throws DatabaseException {
		
    	String var = getURI(graph);
    	String baseURI = base.getURI(graph);
    	return Variables.getRelativeRVI(baseURI, var);

	}

}
