package org.simantics.structural2.scl;

import gnu.trove.map.hash.THashMap;

import java.util.Collections;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;

public class ReadComponentTypeInterfaceRequest extends ResourceRead<Map<String, ComponentTypeProperty>> {
	
    Environment environment;
    
	public ReadComponentTypeInterfaceRequest(Resource resource, Environment environment) {
		super(resource);
		this.environment = environment;
	}

	private void collect(ReadGraph graph, Resource t, THashMap<String, ComponentTypeProperty> result) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		Map<String,Resource> domain = Layer0Utils.getDomainOf(graph, t); 
		for(Map.Entry<String, Resource> entry : domain.entrySet()) {
			String name = entry.getKey();
			Resource relation = entry.getValue();
			if(graph.isSubrelationOf(relation, L0.HasProperty)) {
				String typeName = graph.getPossibleRelatedValue(relation, L0.RequiresValueType, Bindings.STRING);
				if(typeName == null) continue;
				Type type;
				try {
				    type = Environments.getType(environment, typeName);
				} catch(SCLExpressionCompilationException e) {
				    e.printStackTrace();
				    continue;
				}
				ComponentTypeProperty property = new ComponentTypeProperty(relation, type);
				result.put(name, property);
			}
		}
	}
	
	@Override
	public Map<String, ComponentTypeProperty> perform(ReadGraph graph)
			throws DatabaseException {
		if (resource == null)
                  return Collections.emptyMap();

		THashMap<String, ComponentTypeProperty> result = 
				new THashMap<String, ComponentTypeProperty>();
		
		// TODO: For Antti to consider
		// resource == null with procedural user components
		if (resource != null)
		    collect(graph, resource, result);
		//for(Resource t : graph.getSupertypes(resource)) collect(graph, t, result);
		
		return result;
		
	}

}
