package org.simantics.structural2.queries;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public class Terminal {

    private final Resource component;
    private final Resource relation;

    private final int      hash;

    public Terminal(Resource component, Resource relation) {
        this.component = component;
        this.relation = relation;
        this.hash = makeHash();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj.getClass().equals(this.getClass())))
            return false;
        Terminal other = (Terminal) obj;
        return component.equals(other.component) && relation.equals(other.relation);
    }

    public Resource getComponent() {
        return component;
    }

    public Resource getRelation() {
        return relation;
    }

    private int makeHash() {
        return component.hashCode() + relation.hashCode() * 31;
    }

    @Override
    public int hashCode() {
        return hash;
    }

    @Override
    public String toString() {
        return component + " " + relation;
    }

    public String toString(ReadGraph graph) throws DatabaseException {
        return NameUtils.getSafeName(graph, component) + " " + NameUtils.getSafeName(graph, relation);
    }

}
