/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.modelingRules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.SafeName;
import org.simantics.db.exception.DatabaseException;

public class CPTerminal implements IConnectionPoint {

    public final Resource component; // may be null for reference elements
    public final Resource relation;

    public CPTerminal(Resource component, Resource relation) {
        if (relation == null)
            throw new NullPointerException("null relation");
        this.component = component;
        this.relation = relation;
    }

    @Override
    public String toString(ReadGraph g) throws DatabaseException {
        return "CPTerminal(" + 
            g.syncRequest(new SafeName(component)) + ", " +
            g.syncRequest(new SafeName(relation)) + ")";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (component == null ? 0 : component.hashCode());
        result = prime * result + relation.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CPTerminal other = (CPTerminal) obj;
        return (component == null ? other.component == null : component.equals(other.component)) && relation.equals(other.relation);
    }

    /**
     * Convenience method for SCL
     * 
     * @param component
     * @param relation
     * @return
     */
    public static IConnectionPoint makeIConnectionPoint(Resource component, Resource relation) {
        return new CPTerminal(component, relation);
    }
}
