package org.simantics.structural2.modelingRules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;

public class AllowedConnectionTypes extends ResourceRead<Collection<Resource>> {

	public AllowedConnectionTypes(Resource connectionPoint) {
		super(connectionPoint);
	}

	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
		StructuralResource2 STR = StructuralResource2.getInstance(graph);
		Collection<Resource> types = graph.getObjects(resource, STR.AllowsConnectionType);
		Set<Resource> result = new HashSet<Resource>(types);
		for(Resource type : types)
			for(Resource override : graph.getObjects(type, STR.OverridesConnectionType))
				result.remove(override);
		return result;
	}

}
