/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.Connection2;
import org.simantics.structural2.variables.ConnectionBrowser;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;

import gnu.trove.set.hash.THashSet;

public class ConnectionImpl2 implements Connection, Connection2 {

    private final Resource predicate;

    public ConnectionImpl2(Resource predicate) {
        this.predicate = predicate;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((predicate == null) ? 0 : predicate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ConnectionImpl2 other = (ConnectionImpl2) obj;
        if (predicate == null) {
            if (other.predicate != null)
                return false;
        } else if (!predicate.equals(other.predicate))
            return false;
        return true;
    }

    @Override
    public Collection<String> getConnectionPointURIs(ReadGraph graph, Variable component, Resource relationType)
            throws DatabaseException {
        Set<String> result = new THashSet<String>();
        for(VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, component, predicate, relationType)) {
            result.add(desc.getURI(graph));
        }
        return result;
    }

    @Override
    public Collection<Variable> getConnectionPoints(ReadGraph graph, Variable component, Resource relationType)
            throws DatabaseException {
        Set<Variable> result = new THashSet<Variable>();
        for(VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, component, predicate, relationType)) {
            result.add(desc.getVariable(graph));
        }
        return result;
    }

    @Override
    public Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph,
            Variable component, Resource relationType) throws DatabaseException {
        return ConnectionBrowser.flatten(graph, component, predicate, relationType);
    }

    @Override
    public Collection<String> getConnectionPointURIs(ReadGraph graph, Resource relationType) throws DatabaseException {
        throw new IllegalStateException();
    }

    @Override
    public Collection<Variable> getConnectionPoints(ReadGraph graph, Resource relationType) throws DatabaseException {
        throw new IllegalStateException();
    }

    @Override
    public Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph,
            Resource relationType) throws DatabaseException {
        return Collections.emptyList();
        //throw new IllegalStateException();
    }

    @Override
    public Connection2 getConnection2() {
        return this;
    }

}