/*******************************************************************************
 * Copyright (c) 2007, 2025 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.structural2.variables;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardAssertedGraphPropertyVariable;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;

public class StandardProdeduralPropertyVariable extends StandardAssertedGraphPropertyVariable {

	private Object defaultValue;

	public StandardProdeduralPropertyVariable(ReadGraph graph,
			StandardProceduralChildVariable parent,
			StandardGraphPropertyVariable assertedVariable, Object value) throws DatabaseException {
		super(graph, parent, assertedVariable.node, assertedVariable.parentResource, assertedVariable.property.predicate, assertedVariable.getRepresents(graph));
		this.defaultValue = value;
	}
	
	@Override
	protected ValueAccessor getValueAccessor(ReadGraph graph) throws DatabaseException {
		final ValueAccessor valueAccessor = super.getValueAccessor(graph);
		return new ValueAccessor() {
			@Override
			public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
				valueAccessor.setValue(graph, context, value, binding);
			}
			
			@Override
			public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
				valueAccessor.setValue(graph, context, value);
			}
			
			@Override
			public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
				if (node != null) {
					return valueAccessor.getValue(graph, context, binding);
				} else {
					if (binding.isInstance(defaultValue))
						return defaultValue;
					else
						try {
							return Bindings.adapt(defaultValue, Bindings.OBJECT, binding);
						} catch (AdaptException e) {
							throw new DatabaseException("Failed to adapt object " + defaultValue + " to " + binding);
						}
				}
			}
			
			@Override
			public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
				if (node != null) {
					return valueAccessor.getValue(graph, context);
				} else {
					return defaultValue;
				}
			}
			
			@Override
			public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
				return valueAccessor.getDatatype(graph, context);
			}
		};
	}
}
