/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - further development
 *******************************************************************************/
package org.simantics.structural2.variables;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural2.utils.StructuralUtils.StructuralComponentClass;

public class IsLeafType extends ResourceRead<Boolean> {

	public IsLeafType(Resource type) {
		super(type);
	}

	@Override
	public Boolean perform(ReadGraph graph) throws DatabaseException {
		StructuralComponentClass clazz = StructuralComponentClass.get(graph, resource);
		return StructuralComponentClass.PRIMITIVE.equals(clazz);
	}
	
}