/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.variables;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

/**
 * Improves query result cacheability over {@link Connection}.
 * 
 * @author Antti Villberg
 * @since 1.36.0
 * @see Connection
 */
public interface Connection2 {

    /**
     * Return absolute URIs of the connection points. An optional (may be null) relationType may be used
     * to filter the returned connection points.
     */
    Collection<String> getConnectionPointURIs(ReadGraph graph, Variable component, Resource relationType) throws DatabaseException;

    /**
     * Return the connection points. An optional (may be null) relationType may be used
     * to filter the returned connection points.
     */
    Collection<Variable> getConnectionPoints(ReadGraph graph, Variable component, Resource relationType) throws DatabaseException;

    Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph, Variable component, Resource relationType) throws DatabaseException;

}
