package org.simantics.structural2.scl;

import org.simantics.db.Resource;


/**
 * Represents a structural configuration.
 * Has exactly two subclasses {@link StructuralComponent} and {@link StructuralComposite}.
 * 
 * @author Hannu Niemistö
 */
public abstract class StructuralConfiguration<Connection> {
    /*
     * Prevents extending this class outside of this package. 
     */
    public StructuralConfiguration() {
    }
    
    /**
     * Returns underlying resource of the configuration.
     * It can be used to obtain information about the configuration
     * that is not accessible using StructuralComponent or
     * StructuralComposite. For procedural configurations
     * this method may return {@code null} or a resource
     * that represents a template of the configuration.
     */
    public abstract Resource getResource();
    
    /**
     * If the configuration is a root composite of a component
     * type, there are two possible resources that could be
     * reasonably returned in getResource(). New getResource()
     * returns the resource that is linked with IsDefinedBy from
     * the component type and getInstanceResource() returns the
     * instance of the component type. In all other cases this
     * method returns the same resource as getResource().
     */
    public Resource getInstanceResource() {
    	return getResource();
    }
    
    public abstract StructuralComponent<Connection> getContext();
}
