package org.simantics.structural2.scl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class CompileProceduralExpressionValueRequest extends AbstractCompileStructuralValueRequest {
    
    protected final String expression;
    protected final Resource componentType;
    protected final Resource indexRoot;
    
    public CompileProceduralExpressionValueRequest(String expression, Resource componentType, Resource relation, Resource indexRoot) {
    	super(relation);
        this.expression = expression;
        this.componentType = componentType;
        this.indexRoot = indexRoot;
    }
    
    public CompileProceduralExpressionValueRequest(ReadGraph graph, String expression, Variable context) throws DatabaseException {
        this(expression, context.getParent(graph).getType(graph),
                context.getPredicateResource(graph),
                context.getIndexRoot(graph));
    }
    
    public static Object compileAndEvaluate(ReadGraph graph, String expression, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get("graph");
        try {
            Function1<Object,Object> exp = graph.syncRequest(new CompileProceduralExpressionValueRequest(graph, expression, context),
                    TransientCacheListener.instance());
            sclContext.put("graph", graph);
            return exp.apply(context);
        } catch (DatabaseException e) {
            throw (DatabaseException)e;
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
    }
    
    @Override
    protected String getExpressionText(ReadGraph graph) throws DatabaseException {
    	return expression;
    }

    @Override
    protected Resource getIndexRoot(ReadGraph graph) throws DatabaseException {
    	return indexRoot;
    }

    @Override
    protected Resource getComponentType(ReadGraph graph) throws DatabaseException {
    	return componentType;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((relation == null) ? 0 : relation.hashCode());
        result = prime * result + ((componentType == null) ? 0 : componentType.hashCode());
        result = prime * result + ((expression == null) ? 0 : expression.hashCode());
        result = prime * result + ((indexRoot == null) ? 0 : indexRoot.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CompileProceduralExpressionValueRequest other = (CompileProceduralExpressionValueRequest) obj;
        if (relation == null) {
            if (other.relation != null)
                return false;
        } else if (!relation.equals(other.relation))
            return false;
        if (componentType == null) {
            if (other.componentType != null)
                return false;
        } else if (!componentType.equals(other.componentType))
            return false;
        if (expression == null) {
            if (other.expression != null)
                return false;
        } else if (!expression.equals(other.expression))
            return false;
        if (indexRoot == null) {
            if (other.indexRoot != null)
                return false;
        } else if (!indexRoot.equals(other.indexRoot))
            return false;
        return true;
    }

    
}
