/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.queries;

import gnu.trove.set.hash.THashSet;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.CollectionSupport;
import org.simantics.structural.stubs.StructuralResource2;

public class ConnectionSet {
	
    final Set<Resource> connections;
    THashSet<Resource> joins;
    THashSet<Resource> excluded;
    THashSet<Resource> excludedJoins;
    
    StructuralResource2 sr;
    
//    public ConnectionSet() {
//    	
//    }
    
    public ConnectionSet(ReadGraph graph) {
    	sr = StructuralResource2.getInstance(graph);
    	connections = graph.getService(CollectionSupport.class).createSet();
    }

    public boolean excludeConnection(Resource connection) {
        if (excluded == null)
            excluded = new THashSet<Resource>();
        return excluded.add(connection);
    }

    public boolean excludeJoin(Resource join) {
        if (excludedJoins == null)
        	excludedJoins = new THashSet<Resource>();
        return excludedJoins.add(join);
    }
    
    public boolean excludeConnections(Collection<Resource> connections) {
        if (connections.isEmpty())
            return false;
        if (excluded == null)
            excluded = new THashSet<Resource>();
        return excluded.addAll(connections);
    }

    public boolean isExcluded(Resource connection) {
        return excluded != null && excluded.contains(connection);
    }

    public boolean isJoinExcluded(Resource join) {
        return excludedJoins != null && excludedJoins.contains(join);
    }

    public void addConnection(ReadGraph g, Resource connection) throws DatabaseException {
        if(isExcluded(connection))
            return;
        if(connections.add(connection)) {
        	if(sr == null) sr = StructuralResource2.getInstance(g);
            for(Resource join : g.getObjects(connection, sr.IsJoinedBy))
                addJoin(g, join);
        }
    }

    public void addJoin(ReadGraph g, Resource join) throws DatabaseException {
        if(isJoinExcluded(join))
            return;
        if (joins == null)
        	joins = new THashSet<Resource>();
        if(joins.add(join)) {
        	if(sr == null) sr = StructuralResource2.getInstance(g);
            for(Resource connection : g.getObjects(join, sr.Joins))
                addConnection(g, connection);
        }
    }

    public Set<Resource> getConnections() {
        return connections;
    }

    public Set<Resource> getJoins() {
    	if(joins == null) return Collections.emptySet();
        return joins;
    }
}
