/*******************************************************************************
 * Copyright (c) 2014 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.queries;

/**
 * @author Tuukka Lehtonen
 * @see GetComponentLocation
 */
public class ComponentLocation {

    public final boolean insideStructure;
    public final boolean insideModelConfiguration;
    public final boolean hasRepresentation;

    public ComponentLocation(boolean insideStructure, boolean insideConfiguration, boolean hasRepresentation) {
        this.insideStructure = insideStructure;
        this.insideModelConfiguration = insideConfiguration;
        this.hasRepresentation = hasRepresentation;
    }

    @Override
    public String toString() {
        return "[inside structure=" + insideStructure + ", inside model configuration=" + insideModelConfiguration + ", has representation=" + hasRepresentation + "]";
    }

}