/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.modelingRules;

import java.util.Collection;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * @see <a href="https://www.simantics.org/wiki/index.php/Diagram_ontology#Connection_typing_and_constraints">Ontology documentation</a>
 * @author Hannu Niemist
 */
public interface IModelingRules {
	/**
	 * Returns true if the component type can be populated to the diagram.
	 */
	boolean canPopulate(ReadGraph g, 
			Resource componentType) throws DatabaseException;

	/**
	 * Tells if connecting the given connection points is possible
	 * and what the connection type would be.
	 */
	ConnectionJudgement judgeConnection(ReadGraph g, 
			Collection<IConnectionPoint> connectionPoints)
		throws DatabaseException;

	/**
	 * Computes a connection type the the given connection
	 */
	Resource computeConnectionType(ReadGraph g,
			Collection<IConnectionPoint> connectionPoints)
					throws DatabaseException;
	
	/**
	 * Gets attachment relations of already existing connection.
	 */
	IAttachmentRelationMap getAttachmentRelations(ReadGraph g, 
			Resource connection) throws DatabaseException;
	
	/**
	 * Writes the connection type of the connection to graph.
	 */
	void setConnectionType(WriteGraph g,
			Resource connection,
			Resource connectionType) throws DatabaseException;
	
	/**
	 * Reads the connection type of the connection.
	 */
	Resource getConnectionType(ReadGraph g, 
			Resource connection) throws DatabaseException;
	
	Set<CPTerminal> resolveTerminals(ReadGraph g,
			Collection<IConnectionPoint> connectionPoints) throws DatabaseException;
	
}
