/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.modelingRules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

public class CPConnection implements IConnectionPoint {

    public final Resource connection;

    public CPConnection(Resource connection) {
        if (connection == null)
            throw new NullPointerException("null connection");
        this.connection = connection;
    }

    @Override
    public String toString(ReadGraph g) {
        return "CPConnection(" + (connection) + ")";
    }

    @Override
    public int hashCode() {
        return connection.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CPConnection other = (CPConnection) obj;
        return connection.equals(other.connection);
    }

}
