/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.internal.queries;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural2.queries.ConnectionSet;

/**
 * Returns all connections that are reachable from the given ConnectionJoin
 * excluding the provided excluded connections
 * 
 * @author Hannu Niemist&ouml;
 */
public class RelatedConnectionsOfConnectionJoin extends BinaryRead<Resource, Collection<Resource>, Set<Resource>>{

    public RelatedConnectionsOfConnectionJoin(Resource join) {
        super(join, Collections.<Resource>emptySet());
    }

    public RelatedConnectionsOfConnectionJoin(Resource join, Collection<Resource> excludedConnections) {
        super(join, excludedConnections);
    }

    @Override
    public Set<Resource> perform(ReadGraph g) throws DatabaseException {
        ConnectionSet connectionSet = new ConnectionSet(g);
        connectionSet.excludeConnections(parameter2);
        connectionSet.addJoin(g, parameter);
        return connectionSet.getConnections();
    }

}
