/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics;

import org.simantics.internal.Activator;

/**
 * @author Tuukka Lehtonen <tuukka.lehtonen@semantum.fi>
 */
public class ModelBrowserPreferences {

    public static final String  P_NODE                       = Activator.PLUGIN_ID;

    /**
     * Preference for defining the enabled state of virtual graph autosave.
     */
    public static final String  P_ONTOLOGY_VISIBILITY        = "ontology.visibility"; //$NON-NLS-1$

    /**
     * Only non-system shared ontologies (default).
     */
    public static final String     ONTOLOGY_VISIBILITY_SHARED = "shared";

    /**
     * Show all shared ontologies regardless of their system ontology treatment setting.
     */
    public static final String     ONTOLOGY_VISIBILITY_ALL_SHARED = "all-shared";

    /**
     * Show all shared ontologies and system ontologies.
     */
    public static final String     ONTOLOGY_VISIBILITY_ALL = "all";

    public static final String     DEFAULT_ONTOLOGY_VISIBILITY = ONTOLOGY_VISIBILITY_SHARED;

}
