/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.startup;

import org.simantics.CancelStartupException;
import org.simantics.PlatformException;

/**
 * Plug-ins can register a startup extension will be activated and consulted
 * during the Simantics platform startup. The extension must provide an
 * implementation of this interface.
 * 
 * @author Tuukka Lehtonen
 * @since 1.18.1
 */
public interface IStartup {

    /**
     * Will be called in the platform startup thread, i.e. the UI thread during
     * workbench initialization.
     * 
     * <p>
     * Can throw any {@link PlatformException}, such as
     * {@link CancelStartupException} to prevent the platform from starting up
     * for some reason.
     */
    public void preStartup() throws PlatformException;

}
