package org.simantics.internal;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.simantics.internal.startup.StartupRegistry;

public class Activator extends Plugin {

	/**
	 * Name of the log file. 
	 */
	public static String LOG_FILE_NAME = "simantics.log";

	public static final String PLUGIN_ID = "org.simantics";

	// The shared instance
	private static Activator plugin;

	private static BundleContext context;

	private StartupRegistry startupRegistry;

	public static BundleContext getContext() {
		return context;
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext bundleContext) throws Exception {
		super.start(bundleContext);
		Activator.context = bundleContext;
		plugin = this;

		String prop = System.getProperty("osgi.instance.area", null);
		if (prop != null) {
			try {
				URL url = new URL(prop);
				if ("file".equals(url .getProtocol())) {
					try {
						File path = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
						if (!path.exists())
							path.mkdirs();
						if (path.exists() && path.canWrite()) {
							File logFile = new File(path, LOG_FILE_NAME);
							if (!logFile.exists() || (logFile.isFile() && logFile.canWrite()))
								LOG_FILE_NAME = logFile.getAbsolutePath();

						}
					} catch (UnsupportedEncodingException e) {
						// Should never happen since UTF-8 is always supported.
					}
				}
			} catch (MalformedURLException e) {
				// Ignore.
			}
		}		

		startupRegistry = new StartupRegistry();
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext bundleContext) throws Exception {
		Activator.context = null;
		plugin = null;
		super.stop(bundleContext);
	}

	/**
	 * @return the context of this bundle.
	 */
	public static BundleContext getBundleContext() {
		return context;
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	/**
	 * @return
	 */
	public StartupRegistry getStartupRegistry() {
		return startupRegistry;
	}

}
