/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semamtum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics;

import org.simantics.db.Resource;
import org.simantics.platform.ui.PlatformUIResource;

/**
 * @author Antti Villberg
 * @see NameLabelUtil
 */
public enum NameLabelMode {

	NAME("Name"),
	LABEL("Label"),
	NAME_AND_LABEL("Name (Label)"),
	LABEL_AND_NAME("Label (Name)");

	private String label;

	NameLabelMode(String label) {
		this.label = label;
	}

	public String getLabel() {
		return label;
	}

	public NameLabelMode cycle() {
		if(NAME == this) return LABEL;
		else if (LABEL == this) return NAME_AND_LABEL;
		else if (NAME_AND_LABEL == this) return LABEL_AND_NAME;
		else return NAME;
	}

	public Resource asResource(PlatformUIResource UI) {
		if(NAME == this) return UI.NameLabelMode_Name;
		else if (LABEL == this) return UI.NameLabelMode_Label;
		else if (LABEL_AND_NAME == this) return UI.NameLabelMode_LabelAndName;
		else return UI.NameLabelMode_NameAndLabel;
	}

	public static NameLabelMode fromString(String value) {
		if(value == null) return getDefault();
		else return valueOf(value);
	}

	public static NameLabelMode getDefault() {
		return NAME_AND_LABEL;
	}

}