/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.test;

import java.util.Formatter;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.data.PseudoSolver;
import org.simantics.simulation.data.VariableHandle;

public class TestPseudoSolver {
    public static void main(String[] args) throws InterruptedException {
        PseudoSolver solver = new PseudoSolver();
        solver.addListener(new Datasource.DatasourceListener(){

            @Override
            public void onStep(Datasource source) {
                StringBuilder sb = new StringBuilder();
                Formatter f = new Formatter(sb);
                VariableHandle sineHandle = source.openHandle(null, PseudoSolver.SINE, (Binding)Bindings.DOUBLE);
                VariableHandle rampHandle = source.openHandle(null, PseudoSolver.RAMP, (Binding)Bindings.DOUBLE);
                double time = (Double)source.getTime((NumberBinding)Bindings.DOUBLE);
                try {
                    double sine = (Double)sineHandle.getValue();
                    double ramp = (Double)rampHandle.getValue();
                    f.format("%3f: sine=%,5f, ramp=%,5f\n", time, sine, ramp);
                    System.out.print(sb);
                }
                catch (AccessorException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public Executor getExecutor() {
                return null;
            }
        });
        solver.start();
        Thread.sleep(10000L);
        solver.stop();
    }
}

