/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.project;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.simantics.simulation.Activator;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentActivationListener;

public class CountingExperimentActivationListener
implements IExperimentActivationListener {
    IExperimentActivationListener proxy;
    AtomicInteger activationCounter;
    IProgressMonitor monitor;
    AtomicBoolean excepted = new AtomicBoolean(false);

    public CountingExperimentActivationListener(IExperimentActivationListener proxy, int expectedActivations) {
        this(proxy, expectedActivations, null);
    }

    public CountingExperimentActivationListener(IExperimentActivationListener proxy, int expectedActivations, IProgressMonitor monitor) {
        this.proxy = proxy;
        this.activationCounter = new AtomicInteger(expectedActivations);
        this.monitor = monitor;
    }

    @Override
    public void onMessage(IStatus message) {
        this.proxy.onMessage(message);
    }

    @Override
    public void onExperimentActivated(IExperiment experiment) {
        if (this.activationCounter.decrementAndGet() == 0 && !this.excepted.get()) {
            this.proxy.onExperimentActivated(experiment);
        }
    }

    @Override
    public void onFailure(Throwable e) {
        if (this.excepted.compareAndSet(false, true)) {
            this.proxy.onFailure(e);
        } else {
            Activator.logError(e.getMessage(), e);
        }
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.monitor != null ? this.monitor : this.proxy.getProgressMonitor();
    }
}

