/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.test;

import java.util.Formatter;
import java.util.concurrent.Executor;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.data.PseudoSolver;
import org.simantics.simulation.data.Datasource.DatasourceListener;
import org.simantics.simulation.data.VariableHandle;

public class TestPseudoSolver {
	
	public static void main(String[] args) throws InterruptedException {
		
		PseudoSolver solver = new PseudoSolver();
		solver.addListener( new DatasourceListener() {
			@Override
			public void onStep(Datasource source) {
				StringBuilder sb = new StringBuilder();
				Formatter f = new Formatter(sb);
				
				VariableHandle sineHandle = source.openHandle(null, PseudoSolver.SINE, Bindings.DOUBLE);
				VariableHandle rampHandle = source.openHandle(null, PseudoSolver.RAMP, Bindings.DOUBLE);
				
				double time = (Double) source.getTime(Bindings.DOUBLE);
				try {
					double sine = (Double) sineHandle.getValue();
					double ramp = (Double) rampHandle.getValue();
					f.format("%3f: sine=%,5f, ramp=%,5f\n", time, sine, ramp);
					System.out.print(sb);
				} catch (AccessorException e) {
					e.printStackTrace();
				}
			}

			@Override
			public Executor getExecutor() {
				return null;
			}
		} );
		solver.start();
		
		Thread.sleep(10*1000L);
		solver.stop();
	}

}

