/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.project;

import org.simantics.db.Resource;
import org.simantics.project.IProject;
import org.simantics.project.IProjectService;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;


public interface IExperimentManager extends IProjectService {

    /**
     * A hint key for storing an IExperimentManager in an {@link IHintContext}.
     * This is intended to be used with an {@link IProject}.
     */
    Key KEY_EXPERIMENT_MANAGER = new KeyOf(IExperimentManager.class);

    /**
     * The method calls immediately listener.activeExperimentLoaded
     * if there already exists an active experiment.
     */
    void addListener(IExperimentManagerListener listener);
    void removeListener(IExperimentManagerListener listener);

    /** async */
    void startExperiment(Resource experiment, IExperimentActivationListener listener, boolean setActive);
    IExperiment getActiveExperiment();
    IExperiment getExperiment(String identifier);
	IExperiment[] getExperiments();

}
