/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.project;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.simantics.simulation.Activator;
import org.simantics.simulation.experiment.IExperiment;

/**
 * @author Tuukka Lehtonen
 */
public class CountingExperimentActivationListener implements IExperimentActivationListener {

    IExperimentActivationListener proxy;
    AtomicInteger                 activationCounter;
    IProgressMonitor              monitor;
    AtomicBoolean                 excepted = new AtomicBoolean(false);

    public CountingExperimentActivationListener(IExperimentActivationListener proxy, int expectedActivations) {
        this(proxy, expectedActivations, null);
    }

    public CountingExperimentActivationListener(IExperimentActivationListener proxy, int expectedActivations, IProgressMonitor monitor) {
        this.proxy = proxy;
        this.activationCounter = new AtomicInteger(expectedActivations);
        this.monitor = monitor;
    }

    @Override
    public void onMessage(IStatus message) {
        proxy.onMessage(message);
    }

    @Override
    public void onExperimentActivated(IExperiment experiment) {
        if (activationCounter.decrementAndGet() == 0) {
            if (!excepted.get())
                proxy.onExperimentActivated(experiment);
        }
    }

    @Override
    public void onFailure(Throwable e) {
        if (excepted.compareAndSet(false, true))
            proxy.onFailure(e);
        else
            Activator.logError(e.getMessage(), e);
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return monitor != null ? monitor : proxy.getProgressMonitor();
    }

}
