package org.simantics.simulation.export;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;

import org.simantics.history.HistoryException;
import org.simantics.history.csv.CSVFormatter;

public class CSVWriter extends CSVFormatter {
	public File file;
	private String outputEncoding;

	public void setOutputEncoding(String charsetName) {
		this.outputEncoding = charsetName;
	}

	public String getOutputEncoding() {
		return outputEncoding;
	}

	public void write() throws IOException, HistoryException  {
		try {
			Charset cs = outputEncoding != null
					? Charset.forName(outputEncoding)
					: Charset.defaultCharset();

			try (PrintStream ps = new PrintStream(
					new BufferedOutputStream(
							new FileOutputStream(file, true) ),
					false,
					cs))
			{
				formulate2( null, ps );
				ps.flush();
			}
		} catch (IllegalArgumentException e) {
			throw new IOException("Invalid output encoding specified: " + outputEncoding, e);
		}
	}

}