/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.data;

import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;

/**
 * Interface for adapting data provider to HistoryCollector.
 * 
 * @author Toni Kalajainen
 */
public interface Datasource {
	
	Collection<String> getVariables();
	Datatype getType(String key);
	Lock readLock();
	void addListener(DatasourceListener listener);
	void removeListener(DatasourceListener listener);

	/**
	 * Try to open a handle to a variable
	 * 
	 * @param item
	 *            the subscription item to open a handle for
	 * @param key
	 *            requested handle address, should equal
	 *            SubscriptionItem#variableId
	 * @param valueBinding
	 *            binding for handling the requested value
	 * @return Variable Handle or <code>null</code> if handle cannot be resolved
	 *         for any reason
	 */
	VariableHandle openHandle(Bean item, String key, Binding valueBinding);
	
	public interface DatasourceListener {
		
		/**
		 * When listeners are processed, the data source does not proceed.
		 * It is locked, but this is valid only for listeners with executor
		 * as null. Values are typically read within a listener.
		 * 
		 * @param source
		 */
		void onStep(Datasource source);
		
		/**
		 * Get executor where listener is handled.
		 * If returned value is null, listener is handled synchronously in 
		 * current thread.
		 * 
		 * @return
		 */
		Executor getExecutor();
	}

	//
	// The following methods produce sensible values only when the source
	// is locked or within listener (when it is locked).
	// 
	
	Object getTime(NumberBinding binding);

}

