/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.tests;

import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.tests.Messages;

public class SCLTestsDialog
extends FilteredItemsSelectionDialog {
    private static final String SCL_TEST_DIALOG_SETTINGS = "SCLTestDialogSettings";
    private List<TestRunnable> tests;
    Comparator<TestRunnable> comparator = new Comparator<TestRunnable>(){

        @Override
        public int compare(TestRunnable o1, TestRunnable o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public SCLTestsDialog(Shell shell, List<TestRunnable> tests, boolean multi) {
        super(shell, multi);
        this.tests = tests;
        this.setTitle(Messages.SCLTestsDialog_RunSCLTests);
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element != null) {
                    return ((TestRunnable)element).getName();
                }
                return Messages.SCLTestsDialog_NoName;
            }
        });
        this.setSelectionHistory(new ResourceSelectionHistory());
    }

    private TestRunnable findTestByName(String name) {
        for (TestRunnable runnable : this.tests) {
            if (!runnable.getName().equals(name)) continue;
            return runnable;
        }
        return null;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setText(Messages.SCLTestsDialog_RunTest);
        this.setButtonLayoutData(okButton);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings().getSection(SCL_TEST_DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getInstance().getDialogSettings().addNewSection(SCL_TEST_DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){
            {
                String patternText = this.getPattern();
                this.patternMatcher = new SearchPattern();
                if (patternText != null && patternText.length() > 0) {
                    this.patternMatcher.setPattern(patternText);
                } else {
                    this.patternMatcher.setPattern("**");
                }
            }

            public boolean matchItem(Object item) {
                String testName = ((TestRunnable)item).getName();
                if (this.getPattern().indexOf(47) > 0) {
                    return this.matches(testName);
                }
                String[] stringArray = testName.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (this.matches(part)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator<TestRunnable> getItemsComparator() {
        return this.comparator;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask(Messages.SCLTestsDialog_MonitorSearchingTests, this.tests.size());
        for (TestRunnable test : this.tests) {
            contentProvider.add((Object)test, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        return ((TestRunnable)item).getName();
    }

    private class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            String testName = element.getString("test");
            return SCLTestsDialog.this.findTestByName(testName);
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            TestRunnable runnable = (TestRunnable)item;
            element.putString("test", runnable.getName());
        }
    }
}

