/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.modulebrowser;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.osgi.framework.Bundle;
import org.simantics.scl.ui.Activator;

public class PluginSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String PLUGIN_SELECTION_DIALOG = "PLUGIN_SELECTION_DIALOG";
    Collection<Entry> entries;
    Comparator<Entry> comparator = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            if (o1.packageMatchLength != o2.packageMatchLength) {
                return Integer.compare(o2.packageMatchLength, o1.packageMatchLength);
            }
            return o1.bundle.getSymbolicName().compareTo(o2.bundle.getSymbolicName());
        }
    };

    public PluginSelectionDialog(Shell shell, Collection<Entry> entries) {
        super(shell, true);
        this.entries = entries;
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Entry entry = (Entry)element;
                if (entry == null) {
                    return "NULL";
                }
                return entry.bundle.getSymbolicName();
            }
        });
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings().getSection(PLUGIN_SELECTION_DIALOG);
        if (settings == null) {
            settings = Activator.getInstance().getDialogSettings().addNewSection(PLUGIN_SELECTION_DIALOG);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){
            {
                String patternText = this.getPattern();
                this.patternMatcher = new SearchPattern();
                if (patternText != null && patternText.length() > 0) {
                    this.patternMatcher.setPattern(patternText);
                } else {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean matchItem(Object item) {
                Entry entry = (Entry)item;
                String name = entry.bundle.getSymbolicName();
                if (this.getPattern().indexOf(47) > 0) {
                    return this.matches(name);
                }
                String[] stringArray = name.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (this.matches(part)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator getItemsComparator() {
        return this.comparator;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (Entry entry : this.entries) {
            contentProvider.add((Object)entry, itemsFilter);
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    public String getElementName(Object item) {
        Entry entry = (Entry)item;
        return entry.bundle.getSymbolicName();
    }

    public static class Entry {
        Bundle bundle;
        int packageMatchLength;

        public Entry(Bundle bundle, int packageMatchLength) {
            this.bundle = bundle;
            this.packageMatchLength = packageMatchLength;
        }
    }
}

