/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.issues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.simantics.scl.osgi.issues.SCLIssueFactoryProvider;
import org.simantics.scl.osgi.issues.SCLIssueProviderFactory;

public class SCLIssuesContentProvider
implements IStructuredContentProvider {
    public static final int MAX_ISSUE_COUNT = 1000;
    private Viewer viewer;
    boolean disposed = false;
    private AtomicBoolean refreshInProgress = new AtomicBoolean(false);
    private List<SCLIssueProviderFactory.SCLIssueProvider> issueProviders = new ArrayList<SCLIssueProviderFactory.SCLIssueProvider>();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!this.issueProviders.isEmpty()) {
            this.issueProviders.forEach(p -> p.dispose());
            this.issueProviders.clear();
        }
        if (newInput != null) {
            this.issueProviders = SCLIssueFactoryProvider.getSCLIssueProviderFactories().stream().map(f -> f.getSCLIssueProvider()).collect(Collectors.toList());
            this.issueProviders.forEach(p -> p.listenIssues(() -> this.refresh()));
        }
    }

    private void refresh() {
        if (!this.refreshInProgress.compareAndSet(false, true)) {
            return;
        }
        if (this.viewer == null) {
            return;
        }
        final Control control = this.viewer.getControl();
        if (control.isDisposed() || this.disposed) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed() || SCLIssuesContentProvider.this.disposed) {
                    return;
                }
                SCLIssuesContentProvider.this.refreshInProgress.set(false);
                SCLIssuesContentProvider.this.viewer.refresh();
            }
        });
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.issueProviders.forEach(p -> p.dispose());
        this.issueProviders.clear();
        this.disposed = true;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList result = new ArrayList();
        this.issueProviders.forEach(p -> {
            boolean bl = result.addAll(p.getIssues());
        });
        Collections.sort(result);
        return result.toArray();
    }
}

